<?php
/* Script modificado basado en BoxBR Apks Rebrand Panels */

// Mensaje de retroalimentacin
$message = '';
$currentImagePath = 'img/logo.png'; // Ruta por defecto de la imagen del logo

// Procesar el formulario si se enva
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['logo_image'])) {
    $image = $_FILES['logo_image'];
    
    // Verificar si el archivo fue subido correctamente
    if ($image['error'] === UPLOAD_ERR_OK) {
        // Obtener la extensin del archivo
        $imageExtension = pathinfo($image['name'], PATHINFO_EXTENSION);
        
        // Verificar que sea una imagen PNG
        if (strtolower($imageExtension) === 'png') {
            $uploadDir = 'img/';
            $uploadFile = $uploadDir . 'logo.png'; // Ruta del archivo de destino
            
            // Mover el archivo subido al destino
            if (move_uploaded_file($image['tmp_name'], $uploadFile)) {
                $message = "Logo actualizado correctamente.";
                // Redirigir a la misma pgina para que se recargue la imagen
                header("Location: " . $_SERVER['PHP_SELF']);
                exit; // Detener la ejecucin despus de la redireccin
            } else {
                $message = "Error al mover el archivo.";
            }
        } else {
            $message = "Por favor, sube una imagen vlida en formato PNG.";
        }
    } else {
        $message = "Error al subir la imagen. Intenta de nuevo.";
    }
}

// Incluir el header
include 'includes/header.php';

// Modal de confirmacin (si necesitas eliminar la imagen)
echo '<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">' . "\n";
echo '    <div class="modal-dialog">' . "\n";
echo '        <div class="modal-content">' . "\n";
echo '            <div class="modal-header">' . "\n";
echo '                <h2>Confirmar</h2>' . "\n";
echo '            </div>' . "\n";
echo '            <div class="modal-body">' . "\n";
echo '                07Realmente deseas eliminar esta imagen?' . "\n";
echo '            </div>' . "\n";
echo '            <div class="modal-footer">' . "\n";
echo '                <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>' . "\n";
echo '                <a class="btn btn-danger btn-ok">Eliminar</a>' . "\n";
echo '            </div>' . "\n";
echo '        </div>' . "\n";
echo '    </div>' . "\n";
echo '</div>' . "\n";

// Contenido principal
echo '<main role="main" class="col-15 pt-4 px-5">';
echo '<div class="row justify-content-center">';
echo '<div class="col-md-8">';
echo '<h1 class="h3 mb-4 text-gray-800">Logo</h1>';

// Mostrar mensaje si existe
if ($message) {
    echo '<div class="alert alert-info">' . htmlspecialchars($message) . '</div>';
}

// Formulario para actualizar el logo
echo '<form method="post" enctype="multipart/form-data" class="mb-4">';
echo '<div class="input-group">';
echo '<input type="file" name="logo_image" class="form-control" required>';
echo '<div class="input-group-append">';
echo '<button type="submit" class="btn btn-primary">Actualizar Logo</button>';
echo '</div>';
echo '</div>';
echo '</form>';

// Mostrar imagen actual
if (file_exists($currentImagePath)) {
    echo '<h2 class="h4 mb-3">Logo Actual:</h2>';
    echo '<img src="' . htmlspecialchars($currentImagePath) . '?t=' . time() . '" alt="Logo Actual" class="img-fluid mb-3">';
} else {
    echo '<p>No hay logo establecido actualmente.</p>';
}

echo '</div>'; // Cerrar col-md-8
echo '</div>'; // Cerrar row
echo '</main>';

echo '<br><br><br>';

// Incluir el footer
include 'includes/footer.php';

// Incluir script adicional si es necesario
if (file_exists('includes/boxbr.php')) {
    require 'includes/boxbr.php';
}

echo '</body>' . "\n";
?>
