<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Mensaje de retroalimentación
$message = '<div class="alert alert-primary" id="flash-msg"><h4><i class="icon fa fa-check"></i> Configuración Actualizada!</h4></div>';

// Ruta del archivo config.ini
$configFile = './config.ini';

// Obtener la base URL sin el protocolo
$base_url = dirname($_SERVER['PHP_SELF']);

// Leer la configuración del archivo ini
if (file_exists($configFile)) {
    // Leer archivo .ini
    $config_ini = parse_ini_file($configFile, true);
    if ($config_ini === false) {
        die("No se pudo leer el archivo de configuración");
    }

    // Obtener los valores actuales de los campos
    $debug = isset($config_ini['Show']['debug']) ? $config_ini['Show']['debug'] : 'false';
    $web_title = isset($config_ini['titles']['web_title']) ? $config_ini['titles']['web_title'] : '';
    $panel_name = isset($config_ini['titles']['panel_name']) ? $config_ini['titles']['panel_name'] : '';
    $brand_name = isset($config_ini['titles']['brand_name']) ? $config_ini['titles']['brand_name'] : '';
    $contact = isset($config_ini['titles']['contact']) ? $config_ini['titles']['contact'] : '';
} else {
    die("El archivo de configuración no existe.");
}

if (isset($_POST['submit'])) {
    // Actualizar la configuración desde el formulario
    $newDebug = $_POST['debug'] === 'true' ? 'true' : 'false';
    $newWebTitle = $_POST['web_title'];
    $newPanelName = $_POST['panel_name'];
    $newBrandName = $_POST['brand_name'];
    $newContact = $_POST['contact'];

    // Actualizar los valores en el array
    $config_ini['Show']['debug'] = $newDebug;
    $config_ini['titles']['web_title'] =  $newWebTitle;
    $config_ini['titles']['panel_name'] = $newPanelName;
    $config_ini['titles']['brand_name'] = $newBrandName;
    $config_ini['titles']['contact'] = $newContact;

    // Guardar el archivo INI con los nuevos valores
    $configContent = '';
    foreach ($config_ini as $section => $values) {
        $configContent .= "[$section]\n";
        foreach ($values as $key => $value) {
            $configContent .= "$key = \"$value\"\n";
        }
    }

    if (file_put_contents($configFile, $configContent) === false) {
        die("No se pudo guardar el archivo de configuración");
    }

    // Redirigir para evitar reenvío de formulario al recargar
    header('Location: ' . $base_url . '/config.php?message=' . urlencode($message));
    exit;
}

include 'includes/header.php';
?>
<!-- Begin Page Content -->
<div class="container-fluid">

    <?php
    if (isset($_GET['message'])) {
        echo $_GET['message'];
    }
    ?>

    <!-- Page Heading -->
    <h1 class="h3 mb-1 text-gray-800">Configuración de Marquee</h1>

    <!-- Content Row -->
    <div class="row">
        <!-- First Column -->
        <div class="col-lg-12">
            <!-- Custom codes -->
            <div class="card border-left-primary shadow h-100 card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary"><i class="fa fa-cog"></i> Configuración del Panel</h6>
                </div>
                <div class="card-body">
                    <form method="post">
                        <div class="form-group">
                            <label for="debug"><strong>Debug:</strong></label>
                            
                            <select class="form-control" id="debug" name="debug">
                                <option value="true" <?php echo $debug === 'true' ? 'selected' : ''; ?>>Activo</option>
                                <option value="false" <?php echo $debug === 'false' ? 'selected' : ''; ?>>Inactivo</option>
                            </select>
                        </div>
                              <div class="form-group">
                            <label for="panel_name"><strong>Titulo de la WEB:</strong></label>
                            <input class="form-control" id="web_title" name="web_title" value="<?php echo htmlspecialchars($web_title, ENT_QUOTES, 'UTF-8'); ?>" type="text" />
                        </div> 
                            
                        <div class="form-group">
                            <label for="panel_name"><strong>Nombre del Panel:</strong></label>
                            <input class="form-control" id="panel_name" name="panel_name" value="<?php echo htmlspecialchars($panel_name, ENT_QUOTES, 'UTF-8'); ?>" type="text" />
                        </div>
                        <div class="form-group">
                            <label for="brand_name"><strong>Nombre de la Marca:</strong></label>
                            <input class="form-control" id="brand_name" name="brand_name" value="<?php echo htmlspecialchars($brand_name, ENT_QUOTES, 'UTF-8'); ?>" type="text" />
                        </div>
                        <div class="form-group">
                            <label for="contact"><strong>Contacto:</strong></label>
                            <input class="form-control" id="contact" name="contact" value="<?php echo htmlspecialchars($contact, ENT_QUOTES, 'UTF-8'); ?>" type="text" />
                        </div>
                        <button class="btn btn-success btn-icon-split" name="submit" type="submit">
                            <span class="icon text-white-50"><i class="fas fa-check"></i></span><span class="text">Actualizar Configuración</span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<br><br><br>

<?php
include 'includes/footer.php';
?>

</body>
</html>
