<!DOCTYPE html>
<html lang="es-MX">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Cartelera de Películas</title>
  <style>
    * {
      box-sizing: border-box;
    }

    html, body {
      margin: 0;
      padding: 0;
      height: 100vh;
      font-family: sans-serif;
      overflow: hidden;
      position: relative;
      background-color: black;
      position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-size: cover;
    background-position: center;
    }

   /* Fondo dinámico con overlay oscuro */
body::before {
  content: '';
  background-image: url(''); /* Agrega aquí la URL de tu imagen */
  z-index: -2;
  transition: background-image 1s ease-in-out;
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-size: cover;
  background-position: center;
}

/* Capa de oscurecimiento para un 20% de opacidad */
body::after {
  content: '';
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(0, 0, 0, 0.2); /* Oscurecer un 20% */
  z-index: -1; /* Asegurarnos de que esté encima de la imagen pero debajo del contenido */
}
/* Contenedor del carrusel centrado */
    .movie-carousel-container {
      position: absolute;
      top: 45%;
      left: 50%;
      transform: translate(-50%, -50%);
      width: 90%;
      max-width: 1200px;
      overflow: hidden;
      display: flex;
      justify-content: center;
      align-items: center;
      border-radius: 20px;
    }

    .movie-carousel {
      display: flex;
      gap: 10px;
      animation: scrollMovies 20s linear infinite;
    }

    .movie-poster {
      width: 250px;
      height: 375px;
      object-fit: cover;
      border-radius: 10px;
      box-shadow: 0 8px 20px rgba(0, 0, 0, 0.7);
    }


    @keyframes scrollMovies {
      0% { transform: translateX(0); }
      100% { transform: translateX(-50%); }
    }
  </style>
</head>
<body>

  <div class="movie-carousel-container">
    <div class="movie-carousel" id="movieCarousel"></div>
  </div>

  <script>
    const API_KEY = '6b8e3eaa1a03ebb45642e9531d8a76d2';
    const BASE_URL = 'https://api.themoviedb.org/3';
    const movieCarousel = document.getElementById('movieCarousel');

    async function fetchMovies() {
      try {
        const response = await fetch(`${BASE_URL}/movie/popular?api_key=${API_KEY}&language=es-MX&page=1`);
        const data = await response.json();
        const movies = data.results.slice(0, 10);
        renderMovies(movies);
      } catch (error) {
        console.error('Error al obtener películas:', error);
      }
    }

    function renderMovies(movies) {
      movieCarousel.innerHTML = '';
      movies.forEach(movie => {
        const img = document.createElement('img');
        img.src = `https://image.tmdb.org/t/p/w500${movie.poster_path}`;
        img.alt = movie.title;
        img.className = 'movie-poster';
        img.setAttribute('data-bg', `https://image.tmdb.org/t/p/original${movie.backdrop_path}`);
        movieCarousel.appendChild(img);
      });

      // Duplicar para animación infinita
      movieCarousel.innerHTML += movieCarousel.innerHTML;

      // Fondo inicial
      updateBackground();
    }

    function updateBackground() {
      const posters = document.querySelectorAll('.movie-poster');
      const index = Math.floor(performance.now() / 4000) % posters.length;
      const bg = posters[index].getAttribute('data-bg');
      document.styleSheets[0].cssRules[1].style.backgroundImage = `url(${bg})`; // body::before
    }

    function startBackgroundLoop() {
      setInterval(updateBackground, 4000);
    }

    document.addEventListener('DOMContentLoaded', async () => {
      await fetchMovies();
      startBackgroundLoop();
    });
  </script>

</body>
</html>
