<?php
// Definir la base URL de la aplicación
define('BASE_URL', dirname($_SERVER['SCRIPT_NAME'], 2) . '/');

// Definir una nueva base para el archivo de configuración
define('CONFIG_BASE', dirname(__DIR__) . '/');  // Esto apuntará a la carpeta anterior a la carpeta actual

// Ruta del archivo config.ini
$configFile = CONFIG_BASE . 'config.ini';

// Verificar si el archivo existe
if (file_exists($configFile)) {
    // Leer archivo .ini
    $config_ini = parse_ini_file($configFile, true);
    if ($config_ini === false) {
        die("No se pudo leer el archivo de configuración");
    }

    // Obtener los valores de la configuración
    $debug = isset($config_ini['Show']['debug']) ? $config_ini['Show']['debug'] : 'false';
    $panel_name = isset($config_ini['titles']['panel_name']) ? $config_ini['titles']['panel_name'] : '';
    $brand_name = isset($config_ini['titles']['brand_name']) ? $config_ini['titles']['brand_name'] : '';
    $contact = isset($config_ini['titles']['contact']) ? $config_ini['titles']['contact'] : '';
} else {
    die("El archivo de configuración no existe.");
}

// Función para leer la configuración de la marquesina
function readMarquesinaConfig() {
    $configFile = __DIR__ . '/config.txt';  // __DIR__ apunta a la carpeta actual del script

    // Verificar si el archivo existe
    if (file_exists($configFile)) {
        $configContent = file_get_contents($configFile);
        
        // Comprobar si el contenido no está vacío
        if ($configContent === false || trim($configContent) === '') {
            die("El archivo config.txt está vacío o no se puede leer.");
        }

        // Separar las líneas del archivo
        $lines = explode("\n", $configContent);
        
        // Comprobar si hay al menos dos líneas (estado y texto)
        if (count($lines) < 2) {
            die("El archivo config.txt no tiene el formato adecuado.");
        }

        // Asignar el estado y texto de la marquesina
        $marquesinaStatus = trim($lines[0]);
        $marquesinaTexto = trim($lines[1]);

        // Retornar los valores
        return [
            'status' => $marquesinaStatus,
            'texto' => $marquesinaTexto
        ];
    }

    // Valor por defecto si no existe el archivo
    return [
        'status' => 'activo',
        'texto' => 'Este es el texto en movimiento dentro de la marquesina.'
    ];
}

$marquesinaConfig = readMarquesinaConfig();

?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Cargando...</title>
  <style>
html, body {
    margin: 0;
    padding: 0;
    color: white;
    font-family: sans-serif;
    height: 100vh;
    overflow: hidden;
    display: flex;
    justify-content: center;
    align-items: center;
    flex-direction: column;
}

.background {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-image: url('https://image.tmdb.org/t/p/original/fTrQsdMS2MUw00RnzH0r3JWHhts.jpg');
    background-size: cover;
    background-position: center;
    filter: blur(15px); /* Desenfoque del fondo */
    z-index: 0; /* Fondo por detrás del contenido */
}

.container {
    position: relative;
    z-index: 1; /* Asegura que el contenido esté por encima del fondo */
    padding: 20px;
    color: white; /* Color del texto */
    font-size: 24px;
    text-align: center;
}

    /* Loading */
#loader-container {
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  background-color: #000000;
  display: flex;
  justify-content: center;
  align-items: center;
  z-index: 9999; /* Asegura que esté encima de todo */
}


    .bar-wrapper {
      width: 100%;
      height: 5px;
      background-color: #000000;
      overflow: hidden;
    }

    .bar {
      width: 0%;
      height: 100%;
      background-color: #b7b7b7;
      transition: width 0.1s linear;
    }

    /* Logo y texto */
    #welcome {
      position: absolute;
      text-align: center;
      width: 100%;
      display: none;
      top: 25%;
    }

    .logo {
      width: 300px;
      animation: shrinkLogo 0.7s ease-in-out forwards;
      animation-delay: 0.5s;
    }

    @keyframes shrinkLogo {
      from {
        transform: scale(1.5);
      }
      to {
        transform: scale(0.9);
      }
    }

    .text {
      font-size: 32px;
      color: white;
      margin-top: 1px; /* Ajuste para que el texto esté más cerca del logo */
      opacity: 0;
      animation: showText 0.3s ease-in-out forwards;
      animation-delay: 1.2s; /* Se muestra justo después de la animación del logo */
    }

    @keyframes showText {
      from {
        opacity: 0;
        transform: translateY(10px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    /* Estilos para la marquesina */
.marquesina-container {
    width: 100%;
    max-width: 500px;
    height: 40px;
    overflow: hidden;
    background-color: rgb(255 255 255 / 8%);
    border-radius: 15px;
    white-space: nowrap;
    position: absolute;
    top: 190px;
    right: 25%;
    z-index: 2;
    display: <?php echo $marquesinaConfig['status'] === 'activo' ? 'block' : 'none'; ?>;
    }
        
        .marquesina-texto {
            display: inline-block;
            padding-left: 100%;
            white-space: nowrap;
            color: white;
            font-size: 1.5em;
            animation: mover 20s linear infinite;
        }
        @keyframes mover {
            0% { transform: translate(0, 0); }
            100% { transform: translate(-100%, 0); }
        }
        #gradient-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 1;
    background: linear-gradient(to bottom, #ffffff00, #000000);
    pointer-events: none;
}
  </style>
  
</head>
<body>

  <!-- Loader y barra de progreso -->
  <div id="loader-container">
    <div class="bar-wrapper">
      <div class="bar" id="bar"></div>
    </div>
  </div>
          
  <!-- Logo y texto --><div class="background"></div>

  <div id="welcome">
      
    <img id="logo" class="logo" src="<?= BASE_URL ?>img/logo.png?t=<?= time() ?>" alt="Logo">
    <div class="text"><?php echo $config_ini['titles']['panel_name']; ?></div>
  <!-- Marquesina -->
  <?php if ($marquesinaConfig['status'] === 'activo'): ?>
     <div class="marquesina-container" >
            <div class="marquesina-texto">
        <?php echo htmlspecialchars($marquesinaConfig['texto'], ENT_QUOTES, 'UTF-8'); ?>
    </div>  
    </div>
  <?php endif; ?>
  </div>

  

  <script>
    const bar = document.getElementById('bar');
    let percent = 0;

    const interval = setInterval(() => {
      if (percent >= 100) {
        clearInterval(interval);
        document.getElementById('loader-container').style.display = 'none';
        document.getElementById('welcome').style.display = 'block';
      } else {
        percent++;
        bar.style.width = percent + '%';
      }
    }, 20); // velocidad rápida de carga
  </script>

</body>
</html>
