<?php
// Definir la base URL de la aplicación
define('BASE_URL', dirname($_SERVER['SCRIPT_NAME'], 2) . '/');

// Definir una nueva base para el archivo de configuración
define('CONFIG_BASE', dirname(__DIR__) . '/');  // Esto apuntará a la carpeta anterior a la carpeta actual

// Ruta del archivo config.ini
$configFile = CONFIG_BASE . 'config.ini';

// Verificar si el archivo existe
if (file_exists($configFile)) {
    // Leer archivo .ini
    $config_ini = parse_ini_file($configFile, true);
    if ($config_ini === false) {
        die("No se pudo leer el archivo de configuración");
    }

    // Obtener los valores de la configuración
    $debug = isset($config_ini['Show']['debug']) ? $config_ini['Show']['debug'] : 'false';
    $panel_name = isset($config_ini['titles']['panel_name']) ? $config_ini['titles']['panel_name'] : '';
    $brand_name = isset($config_ini['titles']['brand_name']) ? $config_ini['titles']['brand_name'] : '';
    $contact = isset($config_ini['titles']['contact']) ? $config_ini['titles']['contact'] : '';
} else {
    die("El archivo de configuración no existe.");
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Cargando...</title>
  <style>
    html, body {
      margin: 0;
      padding: 0;
      background: black;
      color: white;
      font-family: sans-serif;
      height: 100vh;
      overflow: hidden;
      display: flex;
      justify-content: center;
      align-items: center;
      flex-direction: column;
    }

    /* Loading */
    #loader-container {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background-color: #000000;
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .bar-wrapper {
      width: 100%;
      height: 5px;
      background-color: #000000;
      overflow: hidden;
    }

    .bar {
      width: 0%;
      height: 100%;
      background-color: #b7b7b7;
      transition: width 0.1s linear;
    }

    /* Logo y texto */
    #welcome {
      position: absolute;
      text-align: center;
      width: 100%;
      display: none;
      top: 25%;
    }

    .logo {
      width: 300px;
      animation: shrinkLogo 0.7s ease-in-out forwards;
      animation-delay: 0.5s;
    }

    @keyframes shrinkLogo {
      from {
        transform: scale(1.5);
      }
      to {
        transform: scale(0.9);
      }
    }

    .text {
      font-size: 32px;
      color: white;
      margin-top: 1px; /* Ajuste para que el texto esté más cerca del logo */
      opacity: 0;
      animation: showText 0.3s ease-in-out forwards;
      animation-delay: 1.2s; /* Se muestra justo después de la animación del logo */
    }

    @keyframes showText {
      from {
        opacity: 0;
        transform: translateY(10px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

  </style>
</head>
<body>

  <!-- Loader y barra de progreso -->
  <div id="loader-container">
    <div class="bar-wrapper">
      <div class="bar" id="bar"></div>
    </div>
  </div>

  <!-- Logo y texto -->
  <div id="welcome">
    <!-- Agregamos el parámetro de tiempo para evitar caché -->
    <img id="logo" class="logo" src="<?= BASE_URL ?>img/logo.png?t=<?= time() ?>" alt="Logo">
    <div class="text"><?php echo $config_ini['titles']['panel_name']; ?></div>
    
  </div>


  <script>
    const bar = document.getElementById('bar');
    const percentageText = document.getElementById('percentage');
    let percent = 0;

    const interval = setInterval(() => {
      if (percent >= 100) {
        clearInterval(interval);
        document.getElementById('loader-container').style.display = 'none';
        document.getElementById('welcome').style.display = 'block';

        // Redirigir tras 2 segundos desde que se muestra el logo
        setTimeout(() => {
          window.location.href = './image.php';
        }, 2000);
      } else {
        percent++;
        bar.style.width = percent + '%';
        percentageText.innerText = percent + '%';
      }
    }, 20); // velocidad rápida de carga
  </script>

</body>
</html>
