<?php
// Configuración de la base de datos SQLite
$db_path = './ads.db';
try {
    $db = new SQLite3($db_path);
    $table_name = 'ads';
    // Obtener todos los anuncios
    $res = $db->query("SELECT * FROM $table_name ORDER BY created_on DESC");
    $ads = array();
    while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
        $extension = pathinfo($row['url'], PATHINFO_EXTENSION);
        $ads[] = array(
            "AdUrl" => $row['url'],
            "Title" => $row['title'],
            "Type" => in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif']) ? 'image' : 'video'
        );
    }
    $db->close();
} catch (Exception $e) {
    // Manejo silencioso del error
    $ads = array();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Visualización de Anuncios</title>
  <!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Carrusel de Cartulas</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      background-color: #000;
      overflow: hidden;
    }

    #carousel-container {
      width: 100vw;
      height: 400px; /* alto ajustado al tama09o de las cartulas */
      overflow: hidden;
      position: relative;
    }

    #carousel-track {
      display: flex;
      align-items: center;
      gap: 20px;
      animation: scroll-left 5s linear infinite;
    }

    .carousel-item {
    flex: 0 0 auto;
    width: 250px;
    height: 400px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.5);
}

    .carousel-item img,
    .carousel-item video {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }

    @keyframes scroll-left {
      0% { transform: translateX(0); }
      100% { transform: translateX(-50%); }
    }
  </style>
</head>
<body>

<div id="carousel-container" style="    top: 100px;">
  <div id="carousel-track"></div>
</div>

<script>
  const ads = <?php echo json_encode($ads); ?>;
  const track = document.getElementById('carousel-track');

  function createSlide(media) {
    const slide = document.createElement('div');
    slide.className = 'carousel-item';

    if (media.Type === 'image') {
      const img = document.createElement('img');
      img.src = media.AdUrl;
      img.alt = media.Title;
      slide.appendChild(img);
    } else if (media.Type === 'video') {
      const video = document.createElement('video');
      video.src = media.AdUrl;
      video.muted = true;
      video.loop = true;
      video.autoplay = true;
      video.playsInline = true;
      slide.appendChild(video);
    }

    return slide;
  }

  function loadCarousel(data) {
    for (let i = 0; i < 2; i++) { // duplicamos contenido para el efecto de bucle
      data.forEach(media => {
        const slide = createSlide(media);
        track.appendChild(slide);
      });
    }
  }

  loadCarousel(ads);
</script>

</body>
</html>

</body>
</html>