<?php
$db_path = './ads.db';
try {
    $db = new SQLite3($db_path);
    $table_name = 'ads';
    $res = $db->query("SELECT * FROM $table_name ORDER BY created_on DESC");
    $ads = array();
    while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
        $extension = pathinfo($row['url'], PATHINFO_EXTENSION);
        $ads[] = array(
            "AdUrl" => $row['url'],
            "Title" => $row['title'],
            "Type" => in_array(strtolower($extension), ['jpg', 'jpeg', 'png', 'gif']) ? 'image' : 'video'
        );
    }
    $db->close();
} catch (Exception $e) {
    $ads = array();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Carrusel de Anuncios</title>
  <style>
    body {
      margin: 0;
      height: 100vh;
      overflow: hidden;
      background-color: #000;
    }

    #carousel-container {
      position: relative;
      width: 100vw;
      height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .carousel-item {
      position: absolute;
      width: 100%;
      height: 650px;
      overflow: hidden;
      opacity: 0;
      transition: opacity 1s ease-in-out;
    }

    .carousel-item.active {
      opacity: 1;
      z-index: 1;
    }

    .carousel-item img,
    .carousel-item video {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }

    .overlay {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: linear-gradient(to bottom, rgba(0,0,0,1), rgba(255,255,255,0.05), rgba(0,0,0,1));
      pointer-events: none; /* Permite que el contenido debajo reciba clics si es necesario */
      z-index: 2;
    }
  </style>
</head>
<body>

<div id="carousel-container"></div>

<script>
  const ads = <?php echo json_encode($ads); ?>;
  const container = document.getElementById('carousel-container');

  let currentIndex = 0;
  const slides = [];

  function createSlide(media) {
    const slide = document.createElement('div');
    slide.className = 'carousel-item';

    if (media.Type === 'image') {
      const img = document.createElement('img');
      img.src = media.AdUrl;
      img.alt = media.Title;
      slide.appendChild(img);
    } else if (media.Type === 'video') {
      const video = document.createElement('video');
      video.src = media.AdUrl;
      video.muted = true;
      video.loop = true;
      video.autoplay = true;
      video.playsInline = true;
      slide.appendChild(video);
    }

    // Añadir overlay con degradado encima del contenido
    const overlay = document.createElement('div');
    overlay.className = 'overlay';
    slide.appendChild(overlay);

    container.appendChild(slide);
    slides.push(slide);
  }

  function showSlide(index) {
    slides.forEach((slide, i) => {
      slide.classList.toggle('active', i === index);
    });
  }

  function startCarousel() {
    if (slides.length === 0) return;
    showSlide(currentIndex);
    setInterval(() => {
      currentIndex = (currentIndex + 1) % slides.length;
      showSlide(currentIndex);
    }, 5000);
  }

  ads.forEach(createSlide);
  startCarousel();
</script>

</body>
</html>
